	
////////////////////////////////////////////////////////////
//	File:		"CHighScoreState.cpp"
//	Author:		[AK] Andrew Kryvanis
//	Modified:	[AK] August 05, 2008
//	Purpose:	Defines the high score game state.
//				- Singleton
////////////////////////////////////////////////////////////

#include "CHighScoreState.h"

#include <fstream>					// For reading/writing.

#include "CSGD_TextureManager.h"	// Texture manager.
#include "CSGD_DirectInput.h"		// Direct input.
#include "CGame.h"					// Game

#include "CMainMenuState.h"			// For returning to the main menu.

/* Data Members */

CHighScoreState CHighScoreState::sm_Instance;

/* Constructors */

CHighScoreState::CHighScoreState()
{
	m_nBGImage = -1;
	for (int x = 0; x < 10; x++)
	{
		m_szScores[x] = "---\0";
		m_nScores[x] = 0;
	}
	m_bInputScore = false;
	//this->WriteFile();
	ReadFile();	
}

CHighScoreState* CHighScoreState::GetInstance()
{
	return &sm_Instance;
}

void CHighScoreState::Enter()
{
	m_pTM = CSGD_TextureManager::GetInstance();
	CSGD_FModManager* pFM = CSGD_FModManager::GetInstance();
	m_pDI = CSGD_DirectInput::GetInstance();
	m_pGame = CGame::GetInstance();

	//m_nBGImage = m_pTM->LoadTexture("Resource/TMP_CreditsBackground.bmp");
	//m_nMusicID = pFM->LoadSound("Resource/TMP_HighScoreMusic.mp3", FMOD_LOOP_NORMAL);
}

bool CHighScoreState::Input(float fElapsedTime)
{
	if (m_pDI->GetBufferedKey(DIK_ESCAPE) || m_pDI->GetBufferedJoyButton(JOYSTICK_B))
	{
		//CGame::GetInstance()->ChangeState(CMainMenuState::GetInstance());
	}

	return true;
}

void CHighScoreState::Update(float fElapsedTime)
{

}

void CHighScoreState::Render()
{
	static CSGD_Direct3D* pD3D = CSGD_Direct3D::GetInstance();

	pD3D->SpriteBegin();

	// Background
	//m_pTM->DrawTexture(m_nBGImage, 0.0f, 0.0f, 1.0f);

	//switch(COptionsState::GetInstance()->GetLanguage())
	//{
	//case 0:
	//	//CBitmapFont::GetInstance()->DrawText("Press Escape or Joystick B to Go Back", 20.0f, 557.0f, D3DCOLOR_ARGB(255,255,255,255), .4f, 3);
	//	break;
	//case 1:
	//	//CBitmapFont::GetInstance()->DrawText("Presione el escape o boton de B para volver", 20.0f, 557.0f, D3DCOLOR_ARGB(255,255,255,255), .4f, 3);
	//	break;
	//}

	/*switch(COptionsState::GetInstance()->GetLanguage())
	{
	case 0:
		m_pBF->DrawText("High Scores", 220.0f, 30.0f, D3DCOLOR_XRGB(255, 255, 255), 1.0f, 5);
		break;
	case 1:
		m_pBF->DrawText("Altas Cuentas", 199.0f, 30.0f, D3DCOLOR_XRGB(255, 255, 255), 1.0f, 5);
		break;
	}	*/	

	if (m_bInputScore == true)
	{
		//m_pBF->DrawText("Congratulations!", 220.0f, 100.0f, D3DCOLOR_XRGB(255, 255, 255), 0.7f, 5);
		//m_pBF->DrawText("You've achieved a high score.", 170.0f, 150.0f, D3DCOLOR_XRGB(255, 255, 255), 0.5f, 5);
		//m_pBF->DrawText("Please enter your initials.", 190.0f, 190.0f, D3DCOLOR_XRGB(255, 255, 255), 0.5f, 5);

	}
	else
	{
		// Let's use static so we don't allocate 32 bytes every single frame.
		//static char szBuffer[32];

		//// Go through and show each score.
		//float fYPosition = 200.0f;
		//for (int x = 0; x < 10; x++)
		//{
		//	// Build a display buffer.
		//	sprintf_s(szBuffer, 32, "%0.4i %s", m_nScores[x], m_szScores[x].c_str());

		//	// Draw the display buffer.
		//	m_pBF->DrawText(szBuffer, 320.0f, fYPosition, D3DCOLOR_XRGB(255, 255, 255), 0.5f, 3);

		//	// Let's draw the next score below this one.
		//	fYPosition += 30.0f;
		//}


		pD3D->SpriteEnd();
	}
}

void CHighScoreState::Exit()
{
	CSGD_FModManager::GetInstance()->StopSound(m_nMusicID);

	m_pGame = NULL;
	m_pDI = NULL;
	m_pTM = NULL;
}

bool CHighScoreState::CheckScore(int nScore)
{
	// Go through and see if this score is higher than any existing high scores.
	for (int x = 0; x < 10; x++)
		if (nScore > m_nScores[x])
			return true;

	// We didn't find any lower scores to beat.
	return false;
}

void CHighScoreState::SetInitials(char* szInitials)
{
	m_szInput[0] = szInitials[0];
	m_szInput[1] = szInitials[1];
	m_szInput[2] = szInitials[2];
	m_szInput[3] = '\0';
}

void CHighScoreState::ReadFile()
{
	std::ifstream fIn;
	fIn.open("Resource/TMP_HighScores.bin", std::ios_base::in | std::ios_base::binary);

	if (fIn.is_open())
	{
		fIn.read((char*) m_nScores, sizeof(int) * 10);
		fIn.read((char*) m_szScores, (sizeof(char) * 4) * 10);
		fIn.close();
	}
}

void CHighScoreState::WriteFile()
{
	std::ofstream fOut;
	fOut.open("Resource/TMP_HighScores.bin", std::ios_base::out | std::ios_base::binary | std::ios_base::trunc);

	if (fOut.is_open())
	{
		fOut.write((char*) m_nScores, sizeof(int) * 10);
		fOut.write((char*) m_szScores, (sizeof(char) * 4) * 10);
		fOut.close();
	}
}

bool CHighScoreState::PushScore(int nScore)
{
	// Go through and see if this score is higher than any existing high scores.
	for (int x = 0; x < 10; x++)
	{
		if (nScore > m_nScores[x])
		{
			m_nScores[x] = nScore;
			m_szScores[x] = m_szInput;
			WriteFile();
			return true;
		}
	}

	return false;
}

/* Destructor */

CHighScoreState::~CHighScoreState()
{

}

/* Protected Functions */

/* Private Functions */

